//---------------------------------------------------------------------------

//#include <vcl.h>
#include <conio.h>
#include <stdio.h>
#include <string.h>
#include "types.h"

//#pragma hdrstop

//---------------------------------------------------------------------------

//#pragma argsused
#define MaxMenu 5
#define MaxW 80
#define MaxH 23
#define StdSize 15
#define MaxRec 7
#define MaxRecSize 50
#define StdFileName "data.txt"

//--------------------------------------------------------------------------

int menu (int Max, int x, int y, char * pocz, int Size, int init);

//--------------------------------------------------------------------------

//Deklaracja kartoteki pracownikw
TDataBase *Kartoteka;


char MenuGl[MaxMenu][StdSize] =
        {{"Wprowadz dane"}, {"Wyszukaj"}, {"Zapis bazy"}, {"Wczytaj baze"}, {"Koniec"}};


void SetRect(int x, int y, int w, int h, int mode)
{
  textbackground(1&mode);
  for (int i=0;i<h;i++)
  {
    gotoxy(x, y+i);
    for (int j=0;j<w;j++) cprintf(" ");
  };

};

int strdel(char *s, int poz)
{
  int i = poz;
  while (*(s+i))
  {
    *(s+i) = *(s+i+1);
    i++;
  };
  return strlen(s);
};

//Wczytuje tekst po znaku
int getString(int x, int y, char * zmienna, unsigned Size)
{
  char ch;
  char temp[30] = "";
  strcpy(temp, zmienna);
  unsigned poz=strlen(temp);
  int i;

  textcolor(7);
  gotoxy(x, y);
  i = 0;
  while (temp[i]) cprintf("%c", temp[i++]);

  while (13!=(ch=getch()))
  {
    switch (ch)
    {
      case 0:
        ch = getch();
        switch (ch)
        {
          //delete
          case 83:
            strdel(temp, poz);
          break;

          //kursory
          case 75:
            if (poz) poz--;
          break;

          case 77:
            if (poz<strlen(temp)) poz++;
          break;
        };
        break;

      //backspace
      case 8:
        if (poz) poz--;
        strdel(temp, poz);
      break;

      case 27:
        return 0;

      //Dodanie znaku
      default:
        temp[poz] = (poz==0) ? (ch>='a' && ch<='z')? ch&223 : ch : ch;
        if (poz<Size-2) poz++;
      break;

    };

    gotoxy(x, y);
    i=0;
    while (temp[i]) cprintf("%c", temp[i++]);
    cprintf(" ");
    gotoxy(x+poz, y);
  };

  strcpy(zmienna, temp);
  return poz;
};

//Pyta o konkretny tekst, ktory przypisuje do zmiennej
void ask(const char * pytanie, char * zmienna, int x, int y, int Size)
{
   SetRect(x, y, 50, 6, 15);
   gotoxy(x+1, y);
   textcolor(14);
   cprintf("%s", pytanie);
   getString(x+1, y+2, zmienna, Size);
   SetRect(x, y, 50, 6, 7);
   gotoxy(x+1, y);
   textcolor(6);
   cprintf("%s", pytanie);
};

//Wyswietla pole pytajace o jakies dane osobowe
int edit (TDane * Dane, int x, int y)
{
  char Menu[MaxRec][MaxRecSize];
  int o=0;

  do
  {

  switch (o)
  {
    case 1:
      ask("PODAJ NAZWISKO", (char *) &Dane->Nazwisko, 10, 10, sizeof(Dane->Nazwisko));
    break;
    case 2:
      ask("PODAJ IMIE", (char *) &Dane->Imie, 10, 10, sizeof(Dane->Imie));
    break;
    case 3:
      ask("PODAJ TELEFON", (char *) &Dane->Telefon, 10, 10, sizeof(Dane->Telefon));
    break;
    case 4:
      ask("PODAJ MIEJSCOWOSC", (char *) &Dane->Miejscowosc, 10, 10, sizeof(Dane->Miejscowosc));
    break;
    case 5:
      ask("PODAJ WIEK", (char *) &Dane->Wiek, 10, 10, sizeof(Dane->Wiek));
    break;

    case 6:
      ask("PODAJ ZAWOD", (char *) &Dane->Zawod, 10, 10, sizeof(Dane->Zawod));
    break;
  };

  if (o) o--;

  memset(&Menu[0][0], 0, MaxRec*MaxRecSize);

  //Tworzenie wpisu w menu

  strcat(&Menu[0][0], "Nazwisko : ");
  strcat(&Menu[0][0], Dane->Nazwisko);

  strcat(&Menu[1][0], "Imie : ");
  strcat(&Menu[1][0], Dane->Imie);

  strcat(&Menu[2][0], "Telefon : ");
  strcat(&Menu[2][0], Dane->Telefon);

  strcat(&Menu[3][0], "Miejscowosc : ");
  strcat(&Menu[3][0], Dane->Miejscowosc);

  strcat(&Menu[4][0], "Wiek : ");
  strcat(&Menu[4][0], Dane->Wiek);

  strcat(&Menu[5][0], "Zawod : ");
  strcat(&Menu[5][0], Dane->Zawod);

  strcat(&Menu[6][0], "<< WSTECZ");

  } while
  (0!=(o=menu(MaxRec, x, y, &Menu[0][0], MaxRecSize, o)));


  return 0;
};

//Wyswietla cala liste uporzadkowana
void Search(TDataBase * data)
{
  char * temp;
  int Count = data->Count();
  int SizeX = 30+30;
  int o=0;

  temp = (char *) malloc(SizeX*(Count+1));

  do
  {

  if (o)
  {
    TDane dane;
    memset(&dane, 0, sizeof(TDane));
    TPerson * temp;
    temp = data->GetData(o);
    if (temp) Move(&temp->Dane, &dane, sizeof(TDane));
    edit(&dane, random(MaxW-MaxRecSize)+1, random(MaxH-MaxRec)+1);
    if (temp) Move(&dane, &temp->Dane, sizeof(TDane));
  };

  memset(temp, 0, SizeX*(Count+1));
  int i=0;
  TPerson * Temp = data->First;
  while (Temp)
  {
    Move(&Temp->Dane.Imie, (temp+i*SizeX+30), 30);
    Move(&Temp->Dane.Nazwisko, (temp+i*SizeX), 30);
    Temp = Temp->Next;
    i++;
  };

  strcat(temp+SizeX*Count, "<< WSTECZ ");



  } while (0!=(o=menu(Count+1, 5, 2, temp, SizeX, o)));
  
  free(temp);
};

//Rysuje okno o okreslonym poziomie jasnosci
void DrawAll(int Max, int x, int y, char * pocz, int o, int mode, int Size)
{
  for (int i=0;i<Max;i++)
    {
      textcolor(i==o ? 14&mode : 15&mode);
      textbackground(i==o ? 4&(mode>>1) : 1&(mode>>1));
      gotoxy(x, y+i);
      cprintf(" %d. ", i+1);

      for (int j=0;j<Size;j++) cprintf("%c", *(pocz+j+i*Size));

      cprintf(" ");
    };
};

//Standardowe menu -> wywietla i pozwala na wybranie zadanej opcji
int menu (int Max, int x, int y, char * pocz, int Size, int init)
{
  int o = init;
  char ch = 0;

  do
  {           
    DrawAll(Max, x, y, pocz, o, 15, Size);
    
    ch = getch();

      if (ch==0)
      {
        ch = getch();
        switch (ch)
        {
        case 72: o = (o > 0) ? o-1 : Max-1; break;
        case 80: o = (o < Max-1) ? o+1 : 0; break;
        };
      };
  }
  
  while (ch!=13);
  
  //Rysuje zaciemnona ramke
  DrawAll(Max, x, y, pocz, o, 6, Size);
  
  return (o!=Max-1)? o+1 : 0;
};

int main(int argc, char* argv[])
{
  Kartoteka = new TDataBase;
  clrscr();
  int o=0;
  while (0!=(o = menu(MaxMenu, random(MaxW-20)+1, random(MaxH-MaxMenu)+1, &MenuGl[0][0], StdSize, o)))
  {
    switch (o)
    {
      case 1:
        TDane dane;
        memset(&dane, 0, sizeof(TDane));

        edit(&dane, random(MaxW-MaxRecSize)+1, random(MaxH-MaxRec)+1);
        Kartoteka->Add(&dane);
      break;

      case 2:
        Search(Kartoteka);
      break;

      case 3:
        Kartoteka->SaveToFile(StdFileName);
      break;

      case 4:
        Kartoteka->LoadFromFile(StdFileName);
      break;




    };

    if (o) o--;
  };
  
  delete Kartoteka;
  return 0;
}
//---------------------------------------------------------------------------
 