PROGRAM AI_GOMOKU;

{**********************************************************************

       Gomoku czyli kolko i krzyzyk na polu o rozmiarach 15x15
     Zeby wygrac trzeba postawic 5  kolek lub krzyzykow pod rzad

***********************************************************************}

CONST MAX_R=15;

TYPE
    TNajlepszyRuch=RECORD
      X, Y     :Byte;
      W1, W2   :Byte;
      MAX      :Byte;
      Kier     :Byte;
      Block    :Boolean;
    END;


VAR TAB        :ARRAY[1..MAX_R, 1..MAX_R] OF BYTE;
    NajR, DWA,
	WRO        :TNajlepszyRuch;
    Kier       :Byte;


    Przeciecia :ARRAY [1.. 2, 1..MAX_R, 1..MAX_R] OF Byte;
    Warto      :ARRAY [1.. 2, 1..MAX_R, 1..MAX_R] OF Byte;
    JuzBylo    :ARRAY [1..2, 0..3] OF Boolean;

    KoniecGry  :Boolean;
    Wyjscie,
    Start,
    Pasek      :Boolean;
    KX, KY,
    LX, LY,
    LXN, LYN   :Byte;
    Pl 	       :Byte;
    warunek    :Byte;
    Pierwszy,
    czas       :Longint;



PROCEDURE ZaznaczPrzeciecia(nr, x, y:Byte);
VAR C:Byte;
    Y2, X2, i:Byte;

BEGIN

  FOR C:=0 TO 7 DO
  CASE C OF
    {Sprawdza ile pol mozna zagospodarowac do gory}
    0:BEGIN
        x2:=x;y2:=y;
        i:=0;
    	IF (Y2>1) THEN
        BEGIN
          DEC(y2);INC(i);
          IF TAB[x2, y2]=0 THEN Przeciecia[nr, x2, y2]:=Przeciecia[nr, x2, y2] or (1 shl c);
        END;
      END;

    {Sprawdza ile pol mozna zagospodarowac do gory w prawo}
    1:BEGIN
        x2:=x;y2:=y;
        i:=0;
        IF (Y2>1) and (x2<MAX_R) THEN
    	BEGIN
          DEC(y2);INC(i);INC(x2);
          IF TAB[x2, y2]=0 THEN Przeciecia[nr, x2, y2]:=Przeciecia[nr, x2, y2] or (1 shl c);
        END;
      END;

    {Sprawdza ile pol mozna zagospodarowac w prawo}
    2:BEGIN
        x2:=x;y2:=y;
        i:=0;
    	IF (x2<MAX_R) THEN
        BEGIN
          INC(x2);INC(i);
          IF TAB[x2, y2]=0 THEN Przeciecia[nr, x2, y2]:=Przeciecia[nr, x2, y2] or (1 shl c);
        END;
      END;

    {Sprawdza ile pol mozna zagospodarowac w dol w prawo}
    3:BEGIN
        x2:=x;y2:=y;
        i:=0;
    	IF (Y2<MAX_R) and (x2<MAX_R) THEN
        BEGIN
          INC(y2);INC(i);INC(x2);
          IF TAB[x2, y2]=0 THEN Przeciecia[nr, x2, y2]:=Przeciecia[nr, x2, y2] or (1 shl c);
        END;
      END;

    {Sprawdza ile pol mozna zagospodarowac w dol}
    4:BEGIN
        x2:=x;y2:=y;
        i:=0;
    	IF (Y2<MAX_R) THEN
        BEGIN
          INC(y2);INC(i);
          IF TAB[x2, y2]=0 THEN Przeciecia[nr, x2, y2]:=Przeciecia[nr, x2, y2] or (1 shl c);
        END;
      END;

    {Sprawdza ile pol mozna zagospodarowac w dol w lewo}
    5:BEGIN
        x2:=x;y2:=y;
        i:=0;
    	IF (Y2<MAX_R) and (x2>1) THEN
        BEGIN
          INC(y2);INC(i);DEC(x2);
          IF TAB[x2, y2]=0 THEN Przeciecia[nr, x2, y2]:=Przeciecia[nr, x2, y2] or (1 shl c);
        END;
      END;

    {Sprawdza ile pol mozna zagospodarowac w lewo}
    6:BEGIN
        x2:=x;y2:=y;
        i:=0;
    	IF (x2>1) THEN
        BEGIN
		  INC(i);DEC(x2);
          IF TAB[x2, y2]=0 THEN Przeciecia[nr, x2, y2]:=Przeciecia[nr, x2, y2] or (1 shl c);
        END;
      END;

    {Sprawdza ile pol mozna zagospodarowac w lewo w gore}
    7:BEGIN
        x2:=x;y2:=y;
        i:=0;
    	IF (Y2>1) and (x2>1) THEN
        BEGIN
		  INC(i);DEC(x2);DEC(y2);
          IF TAB[x2, y2]=0 THEN Przeciecia[nr, x2, y2]:=Przeciecia[nr, x2, y2] or (1 shl c);
        END;
      END;
  END; {Do Case'a}
END;

FUNCTION IleBitow(B:Byte):Byte;
VAR a:Byte;
	w:Byte;
BEGIN
  w:=0;
  FOR a:=0 TO 7 DO
    IF (B AND (1 SHL a)<>0) THEN INC(w);

  IleBitow:=w;
END;

PROCEDURE CzyMoznaWygrac(X, Y, nr:Byte);
VAR Suma:ARRAY[0..7] Of Byte;
    C:Byte;
    x2, y2, i:Byte;

PROCEDURE OdlaczGalaz(D:Byte);
BEGIN
  CASE D OF
    {Sprawdza ile pol mozna zagospodarowac do gory}
    0:BEGIN
        x2:=x;y2:=y;
        i:=0;
    	WHILE (i<5) and (Y2>1) DO
        BEGIN
          DEC(y2);INC(i);
          IF NOT (TAB[x2, y2]=nr) THEN Warto[nr, x2, y2]:=Warto[nr, x2, y2] OR (1 SHL (D AND 3)) Else Break;
        END;
      END;

    {Sprawdza ile pol mozna zagospodarowac do gory w prawo}
    1:BEGIN
        x2:=x;y2:=y;
        i:=0;
    	WHILE (i<5) and (Y2>1) and (x2<MAX_R) DO
        BEGIN
          DEC(y2);INC(i);INC(x2);
          IF NOT (TAB[x2, y2]=nr) THEN Warto[nr, x2, y2]:=Warto[nr, x2, y2] OR (1 SHL (D AND 3)) Else Break;
        END;
      END;

    {Sprawdza ile pol mozna zagospodarowac w prawo}
    2:BEGIN
        x2:=x;y2:=y;
        i:=0;
    	WHILE (i<5) and (x2<MAX_R) DO
        BEGIN
          INC(x2);INC(i);
          IF NOT (TAB[x2, y2]=nr) THEN Warto[nr, x2, y2]:=Warto[nr, x2, y2] OR (1 SHL (D AND 3)) Else Break;
        END;
      END;

    {Sprawdza ile pol mozna zagospodarowac w dol w prawo}
    3:BEGIN
        x2:=x;y2:=y;
        i:=0;
    	WHILE (i<5) and (Y2<MAX_R) and (X2<MAX_R) DO
        BEGIN
          INC(y2);INC(i);INC(x2);
          IF NOT (TAB[x2, y2]=nr) THEN Warto[nr, x2, y2]:=Warto[nr, x2, y2] OR (1 SHL (D AND 3)) Else Break;
        END;
      END;

    {Sprawdza ile pol mozna zagospodarowac w dol}
    4:BEGIN
        x2:=x;y2:=y;
        i:=0;
    	WHILE (i<5) and (Y2<MAX_R) DO
        BEGIN
          INC(y2);INC(i);
          IF NOT (TAB[x2, y2]=nr) THEN Warto[nr, x2, y2]:=Warto[nr, x2, y2] OR (1 SHL (D AND 3)) Else Break;
        END;
      END;

    {Sprawdza ile pol mozna zagospodarowac w dol w lewo}
    5:BEGIN
        x2:=x;y2:=y;
        i:=0;
    	WHILE (i<5) and (Y2<MAX_R) and (X2>1) DO
        BEGIN
          INC(y2);INC(i);DEC(x2);
          IF NOT (TAB[x2, y2]=nr) THEN Warto[nr, x2, y2]:=Warto[nr, x2, y2] OR (1 SHL (D AND 3)) Else Break;
        END;
      END;

    {Sprawdza ile pol mozna zagospodarowac w lewo}
    6:BEGIN
        x2:=x;y2:=y;
        i:=0;
    	WHILE (i<5) and (X2>1) DO
        BEGIN
		  INC(i);DEC(x2);
          IF NOT (TAB[x2, y2]=nr) THEN Warto[nr, x2, y2]:=Warto[nr, x2, y2] OR (1 SHL (D AND 3)) Else Break;
        END;
      END;

    {Sprawdza ile pol mozna zagospodarowac w lewo w gore}
    7:BEGIN
        x2:=x;y2:=y;
        i:=0;
    	WHILE (i<5) and (X2>1) and (Y2>1) DO
        BEGIN
		  INC(i);DEC(x2);DEC(y2);
          IF NOT (TAB[x2, y2]=nr) THEN Warto[nr, x2, y2]:=Warto[nr, x2, y2] OR (1 SHL (D AND 3)) Else Break;
        END;
      END;
  END; {Do Case'a}
END;

BEGIN
  FillChar(Suma, 8, 0);

  FOR C:=0 TO 7 DO
  CASE C OF
    {Sprawdza ile pol mozna zagospodarowac do gory}
    0:BEGIN
        x2:=x;y2:=y;
        i:=0;
    	WHILE (i<5) and (Y2>1) DO
        BEGIN
          DEC(y2);INC(i);
          IF NOT (TAB[x2, y2]=nr) THEN Inc(Suma[C]) Else Break;
        END;
      END;

    {Sprawdza ile pol mozna zagospodarowac do gory w prawo}
    1:BEGIN
        x2:=x;y2:=y;
        i:=0;
    	WHILE (i<5) and (Y2>1) and (x2<MAX_R) DO
        BEGIN
          DEC(y2);INC(i);INC(x2);
          IF NOT (TAB[x2, y2]=nr) THEN Inc(Suma[C]) Else Break;
        END;
      END;

    {Sprawdza ile pol mozna zagospodarowac w prawo}
    2:BEGIN
        x2:=x;y2:=y;
        i:=0;
    	WHILE (i<5) and (x2<MAX_R) DO
        BEGIN
          INC(x2);INC(i);
          IF NOT (TAB[x2, y2]=nr) THEN Inc(Suma[C]) Else Break;
        END;
      END;

    {Sprawdza ile pol mozna zagospodarowac w dol w prawo}
    3:BEGIN
        x2:=x;y2:=y;
        i:=0;
    	WHILE (i<5) and (Y2<MAX_R) and (X2<MAX_R) DO
        BEGIN
          INC(y2);INC(i);INC(x2);
          IF NOT (TAB[x2, y2]=nr) THEN Inc(Suma[C]) Else Break;
        END;
      END;

    {Sprawdza ile pol mozna zagospodarowac w dol}
    4:BEGIN
        x2:=x;y2:=y;
        i:=0;
    	WHILE (i<5) and (Y2<MAX_R) DO
        BEGIN
          INC(y2);INC(i);
          IF NOT (TAB[x2, y2]=nr) THEN Inc(Suma[C]) Else Break;
        END;
      END;

    {Sprawdza ile pol mozna zagospodarowac w dol w lewo}
    5:BEGIN
        x2:=x;y2:=y;
        i:=0;
    	WHILE (i<5) and (Y2<MAX_R) and (X2>1) DO
        BEGIN
          INC(y2);INC(i);DEC(x2);
          IF NOT (TAB[x2, y2]=nr) THEN Inc(Suma[C]) Else Break;
        END;
      END;

    {Sprawdza ile pol mozna zagospodarowac w lewo}
    6:BEGIN
        x2:=x;y2:=y;
        i:=0;
    	WHILE (i<5) and (X2>1) DO
        BEGIN
		  INC(i);DEC(x2);
          IF NOT (TAB[x2, y2]=nr) THEN Inc(Suma[C]) Else Break;
        END;
      END;

    {Sprawdza ile pol mozna zagospodarowac w lewo w gore}
    7:BEGIN
        x2:=x;y2:=y;
        i:=0;
    	WHILE (i<5) and (X2>1) and (Y2>1) DO
        BEGIN
		  INC(i);DEC(x2);DEC(y2);
          IF NOT (TAB[x2, y2]=nr) THEN Inc(Suma[C]) Else Break;
        END;
      END;
  END; {Do Case'a}
  FOR C:=0 TO 7 DO
    IF Suma[C]<5 THEN OdlaczGalaz(C);
END;

PROCEDURE DECI(VAR I:Byte; C :Byte;nr:Byte);
BEGIN
  IF (I>0) AND NOT JuzBylo[nr, C] THEN DEC(I);
  JuzBylo[nr, C]:=TRUE;
END;

FUNCTION ObliczZagrozenie(wr, X, Y:Byte;VAR W2:Byte):Byte;

VAR Zagr      :ARRAY [1..2, 0..7] OF Byte;
    Rs, C, IB :Byte;
    Y2, X2, i :Byte;
    wp, nasz  :Byte;
    wrog, ww2,
	IB2       :Byte;
    wezel,
	wezel2    :Boolean;
    warunek1,
    warunek2  :Boolean;
    co        :Byte;
    Blocked   :ARRAY[1..2, 0..3] OF Boolean;
    Warning,
	Warning2  :Boolean;


FUNCTION Zbadaj(C:Byte):Boolean;
BEGIN
        Zbadaj:=False;
        IF (TAB[X2, Y2]=wr) AND (co=wr) THEN
		    BEGIN
			  INC(wp);
              INC(w2);
			END
			ELSE
            IF (TAB[X2, Y2]=nasz) AND (co=nasz) THEN
            BEGIN
              INC(wrog);
              INC(ww2);
            END
			ELSE
            BEGIN
              IF (TAB[X2, Y2]<>co) AND (TAB[X2, Y2]<>0) THEN
              BEGIN
                Blocked[co, C AND 3]:=True;
                {IF (co=wr) THEN DECI(WW2, C AND 3, nasz);
                IF (co=nasz) THEN DECI(W2, C AND 3, wr);}
              END ELSE IF NOT Blocked[nasz, C AND 3] AND (TAB[X2, Y2]=0) THEN
                BEGIN
                  DWA.X:=X;
                  DWA.Y:=Y;
                END;
			  Zbadaj:=TRUE;
            END;
END;

BEGIN
  FillChar(Zagr, 16, 0);

  FOR C:=0 TO 3 DO Blocked[1, C]:=False;
  FOR C:=0 TO 3 DO Blocked[2, C]:=False;

  FOR C:=0 TO 3 DO JuzBylo[1, C]:=False;
  FOR C:=0 TO 3 DO JuzBylo[2, C]:=False;

  nasz:=3-wr;
  w2:=0;
  ww2:=0;

FOR C:=0 TO 7 DO

  IF (Przeciecia[wr  , X, Y] AND (1 SHL C)<>0) OR
     (Przeciecia[nasz, X, Y] AND (1 SHL C)<>0) THEN

  BEGIN
    wp:=0;
    wrog:=0;

  CASE C OF
    {Sprawdza ile pol mozna zagospodarowac do gory}
    4:BEGIN
        x2:=x;y2:=y;
        i:=0;
        IF (y2-1>1) THEN co:=TAB[x2, y2-1] ELSE CO:=0;

    	WHILE (i<4) AND (Y2>1) DO
        BEGIN
          DEC(y2);INC(i);
          IF Zbadaj(C) THEN Break;
        END;
      END;

    {Sprawdza ile pol mozna zagospodarowac do gory w prawo}
    5:BEGIN
        x2:=x;y2:=y;
        i:=0;
        IF (y2-1>1) and (x2+1<MAX_R) THEN co:=TAB[x2+1, y2-1] ELSE CO:=0;

    	WHILE (i<4) and (Y2>1) and (x2<MAX_R) DO
        BEGIN
          DEC(y2);INC(i);INC(x2);
          IF Zbadaj(C) THEN Break;
        END;
      END;

    {Sprawdza ile pol mozna zagospodarowac w prawo}
    6:BEGIN
        x2:=x;y2:=y;
        i:=0;
        IF (x2+1<MAX_R) THEN co:=TAB[x2+1, y2] ELSE CO:=0;

    	WHILE (i<4) and (x2<MAX_R) DO
        BEGIN
          INC(x2);INC(i);
          IF Zbadaj(C) THEN Break;
        END;
      END;

    {Sprawdza ile pol mozna zagospodarowac w dol w prawo}
    7:BEGIN
        x2:=x;y2:=y;
        i:=0;
        IF (y2+1<MAX_R) and (x2+1<MAX_R) THEN co:=TAB[x2+1, y2+1] ELSE CO:=0;
    	WHILE (i<4) and (Y2<MAX_R) and (X2<MAX_R) DO
        BEGIN
          INC(y2);INC(i);INC(x2);
          IF Zbadaj(C) THEN Break;
        END;
      END;

    {Sprawdza ile pol mozna zagospodarowac w dol}
    0:BEGIN
        x2:=x;y2:=y;
        i:=0;
        IF (Y2+1<MAX_R) THEN co:=TAB[x2, y2+1] ELSE CO:=0;

    	WHILE (i<4) and (Y2<MAX_R) DO
        BEGIN
          INC(y2);INC(i);
          IF Zbadaj(C) THEN Break;
        END;
      END;

    {Sprawdza ile pol mozna zagospodarowac w dol w lewo}
    1:BEGIN
        x2:=x;y2:=y;
        i:=0;
        IF (x2-1>1) and (y2+1<MAX_R) THEN co:=TAB[x2-1, y2+1] ELSE CO:=0;

    	WHILE (i<4) and (Y2<MAX_R) and (X2>1) DO
        BEGIN
          INC(y2);INC(i);DEC(x2);
          IF Zbadaj(C) THEN Break;
        END;
      END;

    {Sprawdza ile pol mozna zagospodarowac w lewo}
    2:BEGIN
        x2:=x;y2:=y;
        i:=0;
        IF (x2-1>1) THEN co:=TAB[x2-1, y2] ELSE CO:=0;
    	WHILE (i<4) and (X2>1) DO
        BEGIN
		  INC(i);DEC(x2);
          IF Zbadaj(C) THEN Break;
        END;
      END;

    {Sprawdza ile pol mozna zagospodarowac w lewo w gore}
    3:BEGIN
        x2:=x;y2:=y;
        i:=0;
        IF (y2-1>1) and (x2-1>1) THEN co:=TAB[x2-1, y2-1] ELSE CO:=0;
    	WHILE (i<4) and (X2>1) and (Y2>1) DO
        BEGIN
		  INC(i);DEC(x2);DEC(y2);
          IF Zbadaj(C) THEN Break;
        END;
      END;
  END; {Do Case'a}
    Zagr[wr, C]:=wp;
    Zagr[nasz, C]:=wrog;

  END; {Do FOR}

  wp:=0;
  wrog:=0;

  wezel:=FALSE;
  wezel2:=FALSE;

  IB:=IleBitow(Przeciecia[wr, X, Y]);
  IB2:=IleBitow(Przeciecia[NASZ, X, Y]);

  {W2:=0;ww2:=0;}
  warunek1:=False;
  warunek2:=False;
  Warning:=False;

  FOR C:=0 TO 3 DO
  BEGIN
    IF Blocked[1, C] THEN DECI(ww2, C, nasz);
    IF Blocked[2, C] THEN DECI(w2, C, wr);

    Zagr[wr, C]:=Zagr[wr, C]+Zagr[wr, C+4];
    If wp<Zagr[wr, C] THEN
	  BEGIN
        WARNING:=fALSE;
	    wp:=Zagr[wr, C];
        Kier:=C;
        IF NOT Blocked[wr, C] THEN Warning:=TRUE;
	  END;
    Zagr[nasz, C]:=Zagr[nasz, C]+Zagr[nasz, C+4];

    If wrog<Zagr[nasz, C] THEN
    BEGIN
      WARNING2:=fALSE;
	  wrog:=Zagr[nasz, C];
      WRO.Kier:=C;
      IF NOT Blocked[nasz, C] THEN Warning2:=TRUE;
    END;
    IF (IB>1) AND ((Przeciecia[wr, X, Y] AND 15<>Przeciecia[wr, X, Y] SHR 4)
        OR (IB AND 1=1)) THEN
         wezel:=TRUE;

    IF (IB2>1) AND ((Przeciecia[NASZ, X, Y] AND 15<>Przeciecia[NASZ, X, Y] SHR 4)
        OR (IB2 AND 1=1)) THEN
         wezel2:=TRUE;
  END;

  IF wezel  AND (w2  >0) THEN DEC(w2 );
  IF wezel2 AND (ww2 >0) THEN DEC(ww2);
  WRO.Block:=False;

  IF Warning THEN W2:=W2+10;
  IF Warning2 THEN WW2:=Ww2+10 ELSE WRO.Block:=True;

  IF IleBitow(Przeciecia[wr, X, Y])>1 THEN

      FOR C:=0 TO 3 DO IF (Zagr[wr, C]>=2) AND NOT Blocked[wr, C] THEN
      BEGIN
       IF warunek1 THEN warunek2:=TRUE;
       warunek1:=True;
      END;

  IF warunek1 AND warunek2 THEN Inc(w2, 10);

      warunek1:=False;
      warunek2:=False;

      IF IleBitow(Przeciecia[nasz, X, Y])>1 THEN
      FOR C:=0 TO 3 DO IF (Zagr[nasz, C]>=2) AND NOT Blocked[nasz, C] THEN
      BEGIN
       IF warunek1 THEN warunek2:=TRUE;
       warunek1:=True;
      END;

  IF warunek1 AND warunek2 THEN Inc(Ww2);

      warunek1:=False;
      warunek2:=False;


    WRO.X:=X;
    WRO.Y:=Y;
    WRO.W1:=wrog;
    WRO.W2:=ww2;


  ObliczZagrozenie:=wp;
END;




PROCEDURE SzukajZagrozenia;
VAR A, B    :Byte;
    W1, W2  :Byte;

BEGIN
  LXN:=NajR.X;
  LYN:=NajR.Y;


  FOR A:=1 TO MAX_R DO
  FOR B:=1 TO MAX_R DO
      BEGIN

      IF (TAB[B, A]=0) THEN
         BEGIN
         {AND NOT (Warto[1, B, a] AND (1 SHL Kier)=1 SHL Kier))}

           W1:=ObliczZagrozenie(2, B, A, W2);

           IF (W1>NajR.W1)

		      OR
		      ((WRO.W1>NajR.W1) AND
		      NOT (Warto[2, B, a] AND (1 SHL WRO.Kier)=1 SHL WRO.Kier))

			  OR
		      ((W1=NajR.W1) AND (W2>NajR.W2) AND NOT
			  (Warto[2, B, a] AND (1 SHL WRO.Kier)=1 SHL WRO.Kier))

			  OR
              ((WRO.W1=NajR.W1) AND (WRO.W2>NajR.W2) AND
			  NOT (Warto[2, B, a] AND (1 SHL WRO.Kier)=1 SHL WRO.Kier))

			  OR
			  ((WRO.W1>W1) AND NOT WRO.Block AND NajR.Block AND
			  (WRO.W1+1>=NajR.W1) AND NOT (Warto[2, B, a] AND (1 SHL WRO.Kier)=1 SHL WRO.Kier))
			  THEN
           BEGIN

             IF (W1>WRO.W1) OR ((W1=WRO.W1) AND (W2>WRO.W2)) THEN
               BEGIN

               IF NOT (Warto[1, B, a] AND (1 SHL Kier)=1 SHL Kier)

			   OR (IleBitow(Przeciecia[1, B, A])>1)
			      {((Przeciecia[1, B, A] AND 3<>Kier) OR
			       (Przeciecia[1, B, A] SHR 4<>Kier))} THEN
                 BEGIN
                   NajR.X:=B;
                   NajR.Y:=A;
                   NajR.W1:=W1;
                   NajR.W2:=W2;
                   warunek:=1;
                   NajR.Kier:=Kier;
                 END;
               END ELSE
               BEGIN
                 NajR.X:=B;
                 NajR.Y:=A;
                 NajR.W1:=WRO.W1;
                 NajR.W2:=WRO.W2;
                 NajR.Block:=WRO.Block;
                 warunek:=2;
               END
           END;  {ELSE  (W1>NajR.W1) AND (W1>=MAX)}
         END;  {(TAB[B, A]=0)}
      END; {DO FOR}
END;  {PROCEDURE}


PROCEDURE Wprowadz_wroga(X, Y:Byte);
VAR X1, Y1 :Byte;

BEGIN
  NajR.W1:=0;NajR.W2:=0;
  DWA.X:=0;DWA.Y:=0;DWA.W1:=0;DWA.W2:=0;
  WRO.W1:=0;WRO.W2:=0;WRO.Block:=False;

  TAB[x, y]:=2;
  CzyMoznaWygrac(X, Y, 2);
  ZaznaczPrzeciecia(2, X, Y);
  SzukajZagrozenia;

  IF TAB[NajR.X, NajR.Y]<>0 THEN
     FOR X1:=1 TO MAX_R DO
     FOR Y1:=1 TO MAX_R DO
     IF TAB[X1, Y1]=0 THEN
     BEGIN
       NajR.X:=X1;
       NajR.Y:=Y1;
     END;

  TAB[NajR.X, NajR.Y]:=1;
  CzyMoznaWygrac(NajR.X, NajR.Y, 1);
  ZaznaczPrzeciecia(1, NajR.X, NajR.Y);

END;

PROCEDURE Init;
BEGIN
   ReadLn(Pierwszy, Czas);

   IF Pierwszy=1 THEN
   BEGIN
     NajR.X:=8;NajR.Y:=8;
     TAB[NajR.X, NajR.Y]:=1;
     CzyMoznaWygrac(NajR.X, NajR.Y, 1);
     ZaznaczPrzeciecia(1, NajR.X, NajR.Y);
     WriteLn(NajR.Y,' ',NajR.X);
   END;
END;


BEGIN
  Init;
  Pl:=1;
  WHILE NOT Wyjscie DO
  BEGIN
    ReadLn(KY, KX, czas);
    Wprowadz_wroga(KX, KY);
    WriteLn(NajR.Y,' ',NajR.X);
  END;
END.