{$G+}
UNIT WhatWave;
INTERFACE

CONST
      BufSize     = 26;
      Silence     = 4;
      S_Length    = 100;

TYPE

      PNormalWave =^TNormalWave;
      TNormalWave = RECORD
        Desc      : STRING;
        Buff      : ARRAY[0..BufSize-1] OF Byte;

      END;

      TByteAr= ARRAY[0..65534] OF Byte;

      id_t   = Array[1..4] of Char;
      PWave  =^TWave;

      TRIFF  = Record
                R_Ident : id_t;
                length  : Longint;
                C_Ident : id_t;
                S_Ident : id_t;
                s_length: Longint;
                Format  ,
                Modus   : Word;
                freq    ,
                byte_p_s: LongInt;
                byte_sam,
                bit_sam : Word;
                D_Ident : id_t;
                d_length: LongInt;

              End;

      TWave  = RECORD
               Riff     : TRIFF;
               Bufor    : Pointer;
             END;





FUNCTION Normalize(Wave:PWave):PNormalWave;
FUNCTION CompWave(Wzor, Badany: PNormalWave; Granica : LongInt):LongInt;
FUNCTION LoadWave(CONST Fn: STRING):PWave;
PROCEDURE FreeWave(VAR Wave:PWave);

IMPLEMENTATION


FUNCTION LoadWave(CONST Fn: STRING):PWave;
VAR F:FILE;
    Temp : PWave;


BEGIN
  LoadWave:=NIL;
  Assign(F, Fn);
  {$R-}
  Reset(F, 1);
  {$R+}
  {JESLI NIE MA PLIKU}
  IF IOResult<>0 THEN Exit;

  IF (MaxAvail>=SizeOf(TRIFF)) THEN
  BEGIN
    New(Temp);
    LoadWave:=Temp;
  END ELSE Exit;

  BlockRead(F, Temp^.Riff, SizeOf(TRIFF));

  IF (MaxAvail>=SizeOf(Temp^.Riff.d_length)) THEN
  BEGIN
    GetMem(Temp^.Bufor, Temp^.Riff.d_length);
    BlockRead(F, Temp^.Bufor^, Temp^.Riff.d_length);

  END ELSE Exit;

  Close(F);

END;

PROCEDURE FreeWave(VAR Wave:PWave);
BEGIN
  IF NOT Assigned(Wave) THEN Exit;

  IF Assigned(Wave^.Bufor) THEN
    FreeMem(Wave^.Bufor, Wave^.Riff.d_length);

  Dispose(Wave);
  Wave:=NIL;
END;

PROCEDURE Move32Offs(Src, Dest:Pointer ;Offs, Count : Word); assembler;
ASM
  Mov  Cx, Count
  Mov  Dx, Cx
  And  Dx, 3
  Shr  Cx, 2

  Push Ds

  Lds  Si, Src
  Mov  Ax, Offs
  Add  Si, Ax
  Les  Di, Dest

  Cld
  Db   $F3,$66,$A5

  Mov  Cx, Dx
  Rep  MovSb

  Pop  Ds
END;

{POBIERA PRAWDZIWY POZIOM AMPLITUDY Z WAROSCI WAVE'A B}
FUNCTION GetReal(B:Byte):Byte;
VAR a:Byte;
BEGIN
  ASM
    Mov  Al, B
    Sub  Al, 128
    jnc  @dalej

    Not  Al

    @dalej:
    Mov  a, Al
  END;

  GetReal:=a;
END;


FUNCTION Normalize(Wave:PWave):PNormalWave;
VAR Temp  : PNormalWave;
    NW    : Pointer;
    Wa    : Pointer;
    Count : Word;
    Max   : Byte;

    Pocz, Kon : LongInt;
    i         : LongInt;
    NewSize   : LongInt;
    FreeM     : Pointer;

BEGIN

  Normalize:= NIL;

  {ODCINANIE CISZY}
    i:=0;
    WHILE (GetReal(TByteAr(Wave^.Bufor^)[i])<Silence) AND
          (i<Wave^.Riff.d_length) DO
    BEGIN
      Inc(i);
    END;

    Pocz:=i;

    i:=0;
    WHILE (GetReal(TByteAr(Wave^.Bufor^)[Wave^.Riff.d_length-i-1])<Silence) AND
          (i<(Wave^.Riff.d_length-Pocz)) DO
    BEGIN
      Inc(i);
    END;

    NewSize:=Wave^.Riff.d_length-(i+Pocz);


  IF (MaxAvail>=SizeOf(NewSize)) THEN
  BEGIN
    FreeM:=Wave^.Bufor;

    GetMem(Wave^.Bufor, NewSize);
    Move32Offs(FreeM, Wave^.Bufor, Pocz, NewSize);

    FreeMem(FreeM, Wave^.Riff.d_length);
    Wave^.Riff.d_length:=NewSize;

  END ELSE Exit;


  IF (MaxAvail>=SizeOf(TNormalWave)) THEN
  BEGIN
    New(Temp);
    Normalize:=Temp;
  END ELSE Exit;

  NW := @Temp^.Buff;
  Wa := Wave^.Bufor;
  Max:= 0;

  Count := Wave^.Riff.d_length DIV BufSize;

  ASM
    Les  Di, NW
    Mov  Cx, BufSize

    Push Ds
    Lds  Si, Wa

    @Przepisz8bit:

      { OBLICZANIE SREDNIEJ Count KOLEJNYCH ELEMENTOW }
      Db   $66
      Xor  Dx, Dx
      Db   $66
      Xor  Bx, Bx

      Push Cx
      Mov  Cx, Count


        @DodajSkladowa:

          Mov  Bl, Ds:[Si]
          Sub  Bl, 128

          jnc  @dalej

           Not Bl

          @dalej:

          Db   $66
          Add  Dx, Bx

          Inc  Si

        Loop @DodajSkladowa

      Mov  Ax, Dx

      Db   $66
      Shr  Dx, 16

      {OBLICZANIE SREDNIEJ}
      Mov  Bx, Count

      Div  Bx

      Mov  Es:[Di], Al


          {SPRAWDZANIE MAKSYMALNEJ AMPLITUDY}
          Mov  Bl, Max
          Cmp  Bl, Al

          Jnb  @wieksze

          Mov  Max, Al

          @wieksze:

      Inc  Di
      Pop  Cx

    Loop @Przepisz8bit

    {SKALOWANIE FALI}
    Les  Di, NW
    Mov  Cx, BufSize

    Lds  Si, Wa

    Xor  Dx, Dx

    @SkalujSkladowa:

          Xor  Ax, Ax
          Xor  Bx, Bx
          Mov  Al, Es:[Di]
          Mov  Bx, Ax

          {MNOZENIE PRZEZ 255}
          Shl  Ax, 8
          Sub  Ax, Bx

          {DZIELENIE PRZEZ MAKSYMALNA WARTOSC}

          Mov  Bh, Max

          Div  Bh

          Mov  Es:[Di], Al
          Inc  Di


        Loop @SkalujSkladowa


    Pop  Ds

  END;

END;

FUNCTION CompWave(Wzor, Badany: PNormalWave; Granica : LongInt):LongInt;
VAR Error:LongInt;
    i    :Word;
BEGIN

  Error:=0;
  FOR i:=0 TO BufSize-1 DO
  BEGIN
    Inc(Error, ABS(Wzor^.Buff[i]-Badany^.Buff[i]));
  END;

  CompWave:=Error;

END;

END.